/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.operands;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.OperandException;
import emulator.unittest.hardware.nmos6502.MockMemory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbsoluteTest {
    private Cpu6502 cpu;
    private MockMemory mock_memory;
    private Operand operand;

    @Before
    public void setUp() throws Exception {
        this.cpu = new Cpu6502();
        this.mock_memory = new MockMemory();
        this.cpu.attach(this.mock_memory, null);
        this.cpu.setPC(0);
        this.cpu.setSP(new HwByte(127L));
        this.operand = new Absolute();
    }

    @Test
    public void testGetByteCount() throws Exception {
        this.operand.init(this.cpu);
        Assert.assertEquals((long)2L, (long)this.operand.getByteCount());
    }

    @Test
    public void testGetExtraCycles() throws Exception {
        this.operand.init(this.cpu);
        Assert.assertEquals((long)2L, (long)this.operand.getExtraCycles());
    }

    @Test
    public void testGetByte() throws Exception {
        this.cpu.setPC(291);
        this.operand.init(this.cpu);
        Assert.assertEquals((long)35L, (long)this.operand.getByte().getNumber());
    }

    @Test(expected=OperandException.class)
    public void testGetWord() throws Exception {
        this.operand.init(this.cpu);
        this.operand.getWord();
    }

    @Test
    public void testGetString() throws Exception {
        this.cpu.setPC(291);
        this.operand.init(this.cpu);
        Assert.assertEquals((Object)"$2423", (Object)this.operand.getString());
    }

    @Test
    public void testSetByte() throws Exception {
        this.cpu.setPC(291);
        this.operand.init(this.cpu);
        this.operand.setByte(new HwByte(170L));
        Assert.assertEquals((long)1L, (long)this.mock_memory.getWriteCount());
        Assert.assertEquals((long)9251L, (long)this.mock_memory.getLastAddress());
        Assert.assertEquals((long)170L, (long)this.mock_memory.getLastData());
    }

    @Test(expected=OperandException.class)
    public void testSetWord() throws Exception {
        this.operand.init(this.cpu);
        this.operand.setWord(new HwWord(0L));
    }
}

